﻿/*
VERSION:		1.3
	
DESCRIPTION:
	This is a 2-point collision system intended to be used with any of the 8-directional walk systems.
	It only collides with tiles in a 2-dimensional array.  (ie: maps)
	But it doesn't take anything else into account such as other sprites.
	
	Alternatively, this system can be completely replaced by the advanced collision system which allows multiple types of collision simultaneously.
	
	
USAGE:
	walk_obj.collision  =  new Collision( player_mc, walk_obj, collision_array, -8, -8 );
	
NOTE:
	The collision data should be a 2-dimensional array.
	0 = pass
	1+ = block
	
*/
// Define collision "class"
// use as:		walk_obj.collision = new Collision( player_mc, walk_obj, collision_array );			(an instance of the function)
class WalkCollision
{
	// variables
	var player_mc;			// Reference to the player sprite		(to get their current position)
	var walk_obj;				// Reference to the walk system		(to alter its velocities)
	var collision_array;		// reference to the collision data		(to determine collision)
	var xOffset;				// Shift the collision area
	var yOffset;				// Shift the collision area
	
	
	
	// Constructor()
	function WalkCollision( player_mc, walk_obj, collision_array, xOffset, yOffset )
	{
		this.player_mc = player_mc;
		this.walk_obj = walk_obj;
		this.collision_array = collision_array;
		this.xOffset = (xOffset) ? xOffset : 0;
		this.yOffset = (yOffset) ? yOffset : 0;
	}// CONSTRUCTOR()
	
	
	
	// Main()
	function run()
	{
		// define size
		var size = 7;		// 7 pixels in all directions
		
		// extract velocities
		var xVel = walk_obj.xVel;
		var yVel = walk_obj.yVel;
		
		// horz
		// get direction
		var xDir = Math.abs(xVel) / xVel;
		// make top-right OR top-left point  +  velocity	(map-relative)	(top)
		var xTop = player_mc._x + (size*xDir) + xVel + xOffset;
		var yTop = player_mc._y - size + yOffset;
		// store collision ID of top-right point
		var xTopTile = Math.floor(xTop / 16);
		var yTopTile = Math.floor(yTop / 16);
		var topCollision = collision_array[xTopTile][yTopTile];
		// make bottom-right OR bottom-left point  +  velocity	(map-relative)	(bottom)
		var xBottom = player_mc._x + (size*xDir) + xVel + xOffset;
		var yBottom = player_mc._y + size + yOffset;
		// store collision ID of bottom-right point
		var xBottomTile = Math.floor(xBottom / 16);
		var yBottomTile = Math.floor(yBottom / 16);
		var bottomCollision = collision_array[xBottomTile][yBottomTile];
		// if top or bottom point collided
		if( topCollision != 0  ||
			bottomCollision != 0)
		{// if:  A horz point collided
			// reset horz velocity
			walk_obj.xVel = 0;
		}// if:  A horz point collided
		
		
		// vert
		// get direction
		var yDir = Math.abs(yVel) / yVel;
		// make left-top OR left-bottom point  +  velocity	(map-relative)	(left)
		var xLeft = player_mc._x - size + xOffset;
		var yLeft = player_mc._y + (size*yDir) + yVel + yOffset;
		// store collision ID of left-top point
		var xLeftTile = Math.floor(xLeft / 16);
		var yLeftTile = Math.floor(yLeft / 16);
		var leftCollision = collision_array[xLeftTile][yLeftTile];
		// make right-top OR right-bottom point  +  velocity	(map-relative)	(right)
		var xRight = player_mc._x + size + xOffset;
		var yRight = player_mc._y + (size*yDir) + yVel + yOffset;
		// store collision ID of right-top point
		var xRightTile = Math.floor(xRight / 16);
		var yRightTile = Math.floor(yRight / 16);
		var rightCollision = collision_array[xRightTile][yRightTile];
		// if left or right collided
		if( leftCollision != 0  ||
			rightCollision != 0)
		{// if:  A vert point collided
			// reset horz velocity
			walk_obj.yVel = 0;
		}// if:  A vert point collided
	}// run()
}// WalkCollision class